<?php
session_start();

include 'include/head.php';

if (!isset($_SESSION['user'])) {
    header("Location: login.php");
}

if (isset($_POST['nom'])) {
    try {
        $bdd->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

        $bdd->beginTransaction();
        $requete = $bdd->prepare('INSERT INTO professeur (nom_professeur, prenom_professeur) VALUES (:nom, :prenom)');
        $requete->bindParam(':nom', $_POST['nom']);
        $requete->bindParam(':prenom', $_POST['prenom']);
        $requete->execute();

        $bdd->commit();

        header('Location: professeurs.php');
    } catch (Exception $e) {
        $bdd->rollBack();
        die("Erreur: " . $e->getMessage());
    }

}
include 'include/navigation.php';
?>

    <!-- Page Content -->
    <div id="page-wrapper">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12">
                    <h1 class="page-header">Bienvenue <?php echo htmlspecialchars($_SESSION['user']) ?></h1>
                </div>
                <div class="col-lg-12">
                    <div class="panel panel-default">
                        <div class="panel-heading"> Ajouter un professeur </div>
                        <div class="panel-body">
                            <div class="form-group">
                                <form method="post">
                                    <label>Nom</label>
                                    <input class="form-control" name="nom">
                                    <label>Prénom</label>
                                    <input class="form-control" name="prenom">
                                    <br />
                                    <input type="submit">
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- /.col-lg-12 -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /#page-wrapper -->

<?php
include 'include/foot.php';
